package jamezo97.clonecraft.dna;

import jamezo97.clonecraft.CloneCraft;
import jamezo97.clonecraft.Logger;
import jamezo97.clonecraft.entity.EntitySpawnEgg;
import jamezo97.clonecraft.entity.clone.EntityClone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map.Entry;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityEggInfo;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class DNA {
	
	public DNA(){
		
	}
	
	
	public DNA(ItemStack stack){
		if(stack != null && stack.getTagCompound() != null){
			loadFrom(stack.getTagCompound());
		}
		if(stack.getTagCompound() == null){
			save(stack);
		}
	}
	
	public DNA(NBTTagCompound nbtCompound){
		loadFrom(nbtCompound);
	}
	
	public void save(ItemStack stack){
		if(stack != null){
			stack.setTagCompound(save());
		}
	}
	
	public NBTTagCompound save(){
		return saveTo(new NBTTagCompound());
	}
	
	public void loadFrom(NBTTagCompound nbt){
		currentEntity = nbt.getInteger("currentEntity");
		int[] previousArray = nbt.getIntArray("previous");
		for(int a = 0; a < previousArray.length; a++){
			previous.add(previousArray[a]);
		}
	}
	
	
	
	public NBTTagCompound saveTo(NBTTagCompound nbt){
		if(currentEntity < 1 && previous.size() == 0){
			return null;
		}
		nbt.setInteger("currentEntity", currentEntity);
		nbt.setIntArray("previous", toIntArray(previous));
		
		
		return nbt;
	}
	
	private int[] toIntArray(ArrayList<Integer> list){
		int[] array = new int[list.size()];
		for(int a = 0; a < list.size(); a++){
			array[a] = list.get(a);
		}
		return array;
	}
	
	int currentEntity = -1;
	
	ArrayList<Integer> previous = new ArrayList<Integer>();
	
	public boolean addEntity(Entity e){
		return addEntity(getEntityID(e));
	}
	
	public int getEntityID(Entity e){
		if(e instanceof EntityPlayer || e instanceof EntityClone){
			return CloneCraft.cloneId;
		}
		return EntityList.getEntityID(e);
	}
	
	/**
	 * I wrote this a little while ago, and can't quite remember how it works. I just know what it does:
	 * It returns a String representing all the different names of the entities within in.
	 * @return
	 */
	public String getMixedEntityName(){
		String ret = "";
		if(isFull()){
			if(!isContaminated()){
				ret = getEntityName(currentEntity);
			}else{
				ArrayList<Integer> entitiesNoRepeat = new ArrayList<Integer>();
				for(int a = previous.size()-1; a >= 0; a--){
					entitiesNoRepeat.add(previous.get(a));
				}
				for(int a = 0; a < entitiesNoRepeat.size()-1;){
					if(entitiesNoRepeat.get(a).equals(entitiesNoRepeat.get(a+1))){
						entitiesNoRepeat.remove(a);
					}else{
						a++;
					}
				}
				
				for(int a = 0; a < entitiesNoRepeat.size(); a++){
					String name = getEntityName(entitiesNoRepeat.get(a));
					if(name == null)continue;
					int length = (int)Math.round(name.length()/2);
					int left = name.length() - length;
					int start = (int)Math.round(left * (((float)a)/((float)entitiesNoRepeat.size())));
					int end = start+length;
					if(a+1 == entitiesNoRepeat.size()){
						end = name.length();
					}
					String append = name.substring(start, end);
					
					ret += append.toLowerCase();
				}
			}
			if(ret != null && ret.length() > 0){
				ret = ret.substring(0, 1).toUpperCase() + ret.substring(1);
			}
		}
		

		return ret;
	}
	
	
	int maxPreviousSize = 4;
	
	public boolean addEntity(int entityID){
		if(entityID > 0){
			int lastEntity = -1;
			if(previous.size() > 0){
				lastEntity = previous.get(previous.size()-1);
			}
			if(currentEntity < 1 || previous.size() == 0 || lastEntity != entityID){
				currentEntity = entityID;
				if(lastEntity != entityID){
					if(previous.size() > maxPreviousSize){
						previous.remove(0);
					}
					previous.add(currentEntity);
				}

				return true;
			}
		}
		return false;
	}
	
	public void clear(){
		currentEntity = -1;
		previous.clear();
	}
	
	public void drain(){
		currentEntity = -1;
	}
	
	
	public String getCurrentEntityName(){
		return getEntityName(currentEntity);
	}
	
	public String getEntityName(int id){
		if(id == CloneCraft.cloneId){
			return "Human";
		}
		return EntityList.getStringFromID(id);
	}
	
	public boolean isContaminated(){
		if(previous.size() == 0){
			return false;
		}
		if(!isFull()){
			return true;
		}
		Integer[] ids = getAllIds();
		for(int a = 0; a < ids.length; a++){
			int one = a;
			int two = a+1;
			if(two >= ids.length){
				two = 0;
			}
			if(ids[one].intValue() != ids[two].intValue()){
				return true;
			}
		}
		return false;
	}
	
	public Integer[] getAllIds(){
		return previous.toArray(new Integer[previous.size()]);
	}
	
	public boolean isFull(){
		return currentEntity > 0;
	}
	
	/**
	 * Get's the display name, to... display, for this DNA/blood mixture.
	 * @param itemName The name of the item, IE, test tube
	 * @param containing The stuff inside is, i.e., blood, DNA etc
	 * @return
	 */
	public String getDisplayName(String itemName, String containing){
		boolean isFull = isFull();
		boolean contaminated = isContaminated();
		if(isFull && getCurrentEntityName() != null){
			String currentEntity = getCurrentEntityName();
			return (contaminated?"Contaminated ":"") + currentEntity + " " + containing;
		}else{
			return (contaminated?"Contaminated ":"") + "Empty " + itemName;
		}
	}
	
	public int getColour(){
		int[] arrIds = new int[previous.size()];
		float[] arrStrength = new float[previous.size()];
		float lastStrength = 1.0f;
		for(int a = previous.size()-1; a > -1; a--){
			int id = (previous.size()-1) - a;
			arrIds[id] = getColour(previous.get(a));
			arrStrength[id] = lastStrength;
			lastStrength /= 2;
		}
		return addColours(arrIds, arrStrength);
	}
	
	/**
	 * Gets an array representing the percentage correspondence between the different blood types in the DNA object.
	 * @param d 
	 * @return
	 */
	public IdToPercent[] getIdToPercentArray(float f){
		HashMap<Integer, Float> idToPercent = new HashMap<Integer, Float>();
		float totalPercentage = 0.0f;
		{
			float percent = 1.0f;
			for(int a = previous.size()-1; a > -1; a--){
				int id = previous.get(a);
				totalPercentage += percent;
				if(idToPercent.containsKey(id)){
					idToPercent.put(id, idToPercent.get(id) + percent);
				}else{
					idToPercent.put(id, percent);
				}
				percent /= f;
			}
		}
		IdToPercent[] array = new IdToPercent[idToPercent.size()];
		int index = 0;
		while(!idToPercent.isEmpty()){
			int idMax = -1;
			float max = -1;
			
			Iterator<Entry<Integer, Float>> it = idToPercent.entrySet().iterator();
			while(it.hasNext()){
				Entry<Integer, Float> entry = it.next();
				if(entry.getValue() > max){
					max = entry.getValue();
					idMax = entry.getKey();
				}
			}
			if(idMax == -1){
				Logger.showLineOccured();
				Logger.error("Infinite while loop about to start right here. That could have been fatal!");
				break;
			}
			
			idToPercent.remove(idMax);
			float percent = (Math.round((max / totalPercentage)*10000.0f)/100.0f);
			array[index++] = new IdToPercent(idMax, percent);
		}
		return array;
	}
	
	public void addInfo(List list) {
		IdToPercent[] array = getIdToPercentArray(4.5f);
		for(int a = 0; a < (array.length>4?4:array.length); a++){
			list.add("\2477" + getEntityName(array[a].id) + " \247f: \2475" + array[a].percent + "%");
		}
		list.add(previous.toString());
		list.add(currentEntity + "");
	}
	
	public int getColour(int entityID){
		if(entityID == CloneCraft.cloneId){
			return bloodColour;
		}
		if(EntityList.entityEggs.containsKey(entityID)){
			return ((EntityEggInfo)EntityList.entityEggs.get(entityID)).primaryColor;
		}
		return 0xffffffff;
	}
	
	public static int addColours(int[] colours, float[] percentages){
		float size = 0;
		double allRed = 0;
		double allGreen = 0;
		double allBlue = 0;
		for(int a = 0; a < colours.length; a++){
			size += percentages[a];
			allRed += ((double)((colours[a] >> 16) & 0xff)) * percentages[a];
			allGreen += ((double)((colours[a] >> 8) & 0xff)) * percentages[a];
			allBlue += ((double)((colours[a]) & 0xff)) * percentages[a];
		}
		int red = 0, green = 0, blue = 0;
		if(size > 0){
			red = (int)Math.round(allRed / size);
			green = (int)Math.round(allGreen / size);
			blue = (int)Math.round(allBlue / size);
		}
		if(red < 1)red = 0;
		if(green < 1)green = 0;
		if(blue < 1)blue = 0;
		if(red > 255)red = 255;
		if(green > 255)green = 255;
		if(blue > 255)blue = 255;
		return (red << 16) | (green << 8) | (blue);
	}
	
	/***
	 * Fills this DNA object with the other. Kinda like mixing the two together.
	 * @param dna
	 */
	public void fillWith(DNA nData){
		this.currentEntity = nData.currentEntity;
		if(!sameContamination(nData)){
			for(int a = 0; a < nData.previous.size(); a++){
				if(previous.size() > maxPreviousSize){
					previous.remove(0);
				}
				previous.add(nData.previous.get(a));
			}
		}
/*		if(nData.previous.size() != 1 || previous.size() != 1 || previous.get(0) != nData.previous.get(0)){
			
		}*/
	}
	
	public boolean sameContamination(DNA dna){
		List<Integer> l1 = previous;
		List<Integer> l2 = dna.previous;
		if(l1.size() == l2.size()){
			for(int a = 0; a < l1.size(); a++){
				if(!l1.get(a).equals(l2.get(a))){
					return false;
				}
			}
			return true;
		}
		return false;
	}
	
	public final static int bloodColour = 0xff851212;

	
	
	public class IdToPercent{
		int id;
		float percent;
		public IdToPercent(int id, float percent){
			this.id = id;
			this.percent = percent;
		}
		
	}
	
	
	
	public Entity spawnEntity(double posX, double posY, double posZ, World world){
		Entity toSpawn = null;
		if(!isContaminated()){
			try{
				toSpawn = EntityList.createEntityByID(currentEntity, world);
			}catch(Exception e){
				e.printStackTrace();
			}
		}else{
			
		}
		if(toSpawn != null){
			
			
			toSpawn.setPosition(posX, posY, posZ);
			
			if(toSpawn instanceof EntityLiving){
				((EntityLiving)toSpawn).onSpawnWithEgg(null);
			}
			
			world.spawnEntityInWorld(toSpawn);
			return toSpawn;
		}else{
			Logger.error("Could not spawn entity with ids: " + previous.toString());
		}
		return toSpawn;
	}

	public Entity spawn(MovingObjectPosition mop, EntitySpawnEgg egg) {
		if(isFull()){
			double x = mop.hitVec.xCoord, y = mop.hitVec.yCoord, z = mop.hitVec.zCoord;
			if(mop.entityHit != null){
//				x += .01f;
//				z += .01f;
			}else{
				switch(mop.sideHit){
				case 0: y-=2; break;
				case 2: z-=.5; break;
				case 3: z+=.5; break;
				case 4: x-=.5; break;
				case 5: x+=.5; break;
				}
			}
			
			return spawnEntity(x, y, z, egg.worldObj);
		}
		return null;
	}
}
